/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.shader;

import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.graphics.shader.ShaderProgram;
import icyllis.modernui.platform.RenderCore;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL43C;

public final class Shader {
    private static final Object2ObjectMap<ResourceLocation, Shader> SHADERS = new Object2ObjectAVLTreeMap();
    private final ResourceLocation mLocation;
    private final int mId;
    private int mAttachCount = 0;
    private boolean mDeleted = false;

    private Shader(ResourceLocation location, int id) {
        this.mLocation = location;
        this.mId = id;
    }

    public void attach(@Nonnull ShaderProgram program) {
        if (this.mAttachCount == Integer.MIN_VALUE) {
            throw new IllegalStateException(this + " has been deleted.");
        }
        ++this.mAttachCount;
        GL43C.glAttachShader((int)program.mId, (int)this.mId);
        if (this.mDeleted) {
            ModernUI.LOGGER.warn(RenderCore.MARKER, "{} is marked as deleted, but the shader is still trying to attach to program {}", (Object)this, (Object)program);
        }
    }

    public void detach(@Nonnull ShaderProgram program) {
        if (this.mAttachCount > 0) {
            --this.mAttachCount;
            GL43C.glDetachShader((int)program.mId, (int)this.mId);
            if (this.mAttachCount == 0 && this.mDeleted) {
                SHADERS.remove((Object)this.mLocation);
                this.mAttachCount = Integer.MIN_VALUE;
            }
        } else {
            ModernUI.LOGGER.warn(RenderCore.MARKER, "Try to detach {} from {}, but the shader is not attached to any program", (Object)this, (Object)program);
        }
    }

    public int getAttachCount() {
        return this.mAttachCount;
    }

    public void delete() {
        if (!this.mDeleted) {
            GL43C.glDeleteShader((int)this.mId);
            if (this.mAttachCount <= 0) {
                SHADERS.remove((Object)this.mLocation);
                this.mAttachCount = Integer.MIN_VALUE;
            }
            this.mDeleted = true;
        }
    }

    @RenderThread
    public static Shader getOrCreate(IResourceManager manager, ResourceLocation location, Type type) throws IOException {
        Shader shader;
        block8: {
            shader = (Shader)SHADERS.get((Object)location);
            if (shader != null) {
                return shader;
            }
            String path = manager == null ? System.getenv().getOrDefault("MOD_ASSETS", "").replace('\\', '/') + location.func_110624_b() + '/' + location.func_110623_a() : "";
            try (BufferedInputStream stream = new BufferedInputStream(manager == null ? new FileInputStream(path) : manager.func_199002_a(location).func_199027_b());){
                String src = RenderCore.readStringASCII(stream);
                if (src != null) {
                    int id = GL43C.glCreateShader((int)type.mGlType);
                    GL43C.glShaderSource((int)id, (CharSequence)src);
                    GL43C.glCompileShader((int)id);
                    if (GL43C.glGetShaderi((int)id, (int)35713) == 1) {
                        shader = new Shader(location, id);
                        SHADERS.put((Object)location, (Object)shader);
                        break block8;
                    }
                    String y = StringUtils.trim((String)GL43C.glGetShaderInfoLog((int)id, (int)32768));
                    throw new IOException("Failed to compile " + type.getName() + " shader (" + location + ") : " + y);
                }
                throw new IOException("Failed to read shader source (" + location + ")");
            }
        }
        return shader;
    }

    public static void deleteAll() {
        SHADERS.values().forEach(Shader::delete);
        if (!SHADERS.isEmpty()) {
            throw new IllegalStateException("There are still " + SHADERS.size() + " shaders attaching to some programs.");
        }
    }

    public static enum Type {
        VERTEX(35633),
        FRAGMENT(35632),
        GEOMETRY(36313),
        TESS_CONTROL(36488),
        TESS_EVALUATION(36487),
        COMPUTE(37305);

        private final int mGlType;

        private Type(int glType) {
            this.mGlType = glType;
        }

        @Nonnull
        private String getName() {
            return this.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        }
    }
}

